/*
 * Decompiled with CFR 0.152.
 */
package com.marth7th.solidarytinker.util.method;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class ModifierLevel {
    public static int getMainhandModifierlevel(LivingEntity entity, ModifierId modifierId) {
        if (entity != null && entity instanceof Player) {
            Player player = (Player)entity;
            ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.MAINHAND));
            if (!toolStack.isBroken()) {
                return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.MAINHAND), (ModifierId)modifierId);
            }
        }
        return 0;
    }

    public static int getOffhandModifierlevel(LivingEntity entity, ModifierId modifierId) {
        if (entity != null && entity instanceof Player) {
            Player player = (Player)entity;
            ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.OFFHAND));
            if (!toolStack.isBroken()) {
                return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.OFFHAND), (ModifierId)modifierId);
            }
        }
        return 0;
    }

    public static int getEachHandsTotalModifierlevel(LivingEntity entity, ModifierId modifierId) {
        if (entity != null && entity instanceof Player) {
            Player player = (Player)entity;
            ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.MAINHAND));
            if (!toolStack.isBroken()) {
                return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.MAINHAND), (ModifierId)modifierId) + ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.OFFHAND), (ModifierId)modifierId);
            }
        }
        return 0;
    }

    public static boolean EachHandsHaveModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return ModifierLevel.getMainhandModifierlevel(entity, modifierId) > 0 && ModifierLevel.getOffhandModifierlevel(entity, modifierId) > 0;
    }

    public static boolean HandsHaveModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return ModifierLevel.getEachHandsTotalModifierlevel(entity, modifierId) > 0;
    }

    public static int getHeadModifierlevel(LivingEntity entity, ModifierId modifierId) {
        if (entity != null && entity instanceof Player) {
            Player player = (Player)entity;
            ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.HEAD));
            if (!toolStack.isBroken()) {
                return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.HEAD), (ModifierId)modifierId);
            }
        }
        return 0;
    }

    public static int getChestModifierlevel(LivingEntity entity, ModifierId modifierId) {
        if (entity != null && entity instanceof Player) {
            Player player = (Player)entity;
            ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.CHEST));
            if (!toolStack.isBroken()) {
                return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.CHEST), (ModifierId)modifierId);
            }
        }
        return 0;
    }

    public static int getLegsModifierlevel(LivingEntity entity, ModifierId modifierId) {
        if (entity != null && entity instanceof Player) {
            Player player = (Player)entity;
            ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.LEGS));
            if (!toolStack.isBroken()) {
                return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.LEGS), (ModifierId)modifierId);
            }
        }
        return 0;
    }

    public static int getFeetsModifierlevel(LivingEntity entity, ModifierId modifierId) {
        if (entity != null && entity instanceof Player) {
            Player player = (Player)entity;
            ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(EquipmentSlot.FEET));
            if (!toolStack.isBroken()) {
                return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(EquipmentSlot.FEET), (ModifierId)modifierId);
            }
        }
        return 0;
    }

    public static boolean inventoryHasThisModifier(LivingEntity entity, ModifierId modifierId) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (ModifierUtil.getModifierLevel((ItemStack)stack, (ModifierId)modifierId) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static int getTotalArmorModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return ModifierLevel.getHeadModifierlevel(entity, modifierId) + ModifierLevel.getChestModifierlevel(entity, modifierId) + ModifierLevel.getLegsModifierlevel(entity, modifierId) + ModifierLevel.getFeetsModifierlevel(entity, modifierId);
    }

    public static int getAllSlotModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return ModifierLevel.getTotalArmorModifierlevel(entity, modifierId) + ModifierLevel.getEachHandsTotalModifierlevel(entity, modifierId);
    }

    public static boolean EachaArmorHasModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return ModifierLevel.getHeadModifierlevel(entity, modifierId) > 0 && ModifierLevel.getChestModifierlevel(entity, modifierId) > 0 && ModifierLevel.getLegsModifierlevel(entity, modifierId) > 0 && ModifierLevel.getFeetsModifierlevel(entity, modifierId) > 0;
    }

    public static boolean EquipHasModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return ModifierLevel.getTotalArmorModifierlevel(entity, modifierId) > 0 || ModifierLevel.HandsHaveModifierlevel(entity, modifierId);
    }

    public static List<Modifier> getCurioModifierInstanceList(Player player, ModifierId modifier) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        LazyOptional handler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        if (handler.resolve().isPresent()) {
            for (ICurioStacksHandler curios : ((ICuriosItemHandler)handler.resolve().get()).getCurios().values()) {
                for (int i = 0; i < curios.getSlots(); ++i) {
                    ItemStack stack = curios.getStacks().getStackInSlot(i);
                    if (stack.m_41619_() || !stack.m_204117_(TinkerTags.Items.MODIFIABLE)) continue;
                    list.add(stack);
                }
            }
        }
        ArrayList<Modifier> modifierList = new ArrayList<Modifier>();
        for (ItemStack curio : list) {
            ToolStack view = ToolStack.from((ItemStack)curio);
            Modifier ModifierInstance = view.getModifier(modifier).getModifier();
            modifierList.add(ModifierInstance);
        }
        return modifierList;
    }

    public static int curioModifierLevel(LivingEntity entity, ModifierId modifierId) {
        if (entity != null && entity instanceof Player) {
            ItemStack curios;
            Iterator<Object> iterator;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            LazyOptional handler = CuriosApi.getCuriosHelper().getCuriosHandler(entity);
            if (handler.resolve().isPresent()) {
                iterator = ((ICuriosItemHandler)handler.resolve().get()).getCurios().values().iterator();
                while (iterator.hasNext()) {
                    curios = (ICurioStacksHandler)iterator.next();
                    for (int i = 0; i < curios.getSlots(); ++i) {
                        ItemStack stack = curios.getStacks().getStackInSlot(i);
                        if (stack.m_41619_() || !stack.m_204117_(TinkerTags.Items.MODIFIABLE)) continue;
                        list.add(stack);
                    }
                }
            }
            if ((iterator = list.iterator()).hasNext()) {
                curios = (ItemStack)iterator.next();
                return ModifierUtil.getModifierLevel((ItemStack)curios, (ModifierId)modifierId);
            }
        }
        return 0;
    }
}

